/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.simple;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.GroupExclude;
import org.gradle.internal.component.model.IvyArtifactName;

final class DefaultGroupExclude
implements GroupExclude {
    private final String group;
    private final int hashCode;

    private DefaultGroupExclude(String group) {
        this.group = group;
        this.hashCode = group.hashCode();
    }

    static GroupExclude of(String group) {
        return new DefaultGroupExclude(group);
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public boolean excludes(ModuleIdentifier module) {
        return this.group.equals(module.getGroup());
    }

    @Override
    public boolean excludesArtifact(ModuleIdentifier module, IvyArtifactName artifactName) {
        return false;
    }

    @Override
    public boolean mayExcludeArtifacts() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultGroupExclude that = (DefaultGroupExclude)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        return this.group.equals(that.group);
    }

    public int hashCode() {
        return this.group.hashCode();
    }

    public String toString() {
        return "{\"exclude group\" : \"" + this.group + "\"}";
    }
}

