/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.plugins.ide.internal.tooling.GradleProjectBuilderInternal;
import org.gradle.plugins.ide.internal.tooling.GradleProjectBuilderOptions;
import org.gradle.plugins.ide.internal.tooling.ToolingModelBuilderSupport;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleProject;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleProjectTask;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;

public class GradleProjectBuilder
implements GradleProjectBuilderInternal {
    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.GradleProject");
    }

    public Object buildAll(String modelName, Project project) {
        return this.buildForRoot(project);
    }

    @Override
    public DefaultGradleProject buildForRoot(Project project) {
        boolean realizeTasks = GradleProjectBuilderOptions.shouldRealizeTasks();
        ProjectState rootProjectState = ((ProjectInternal)project.getRootProject()).getOwner();
        return GradleProjectBuilder.buildHierarchy(rootProjectState, realizeTasks);
    }

    private static DefaultGradleProject buildHierarchy(ProjectState project, boolean realizeTasks) {
        List children = project.getChildProjects().stream().map(it -> GradleProjectBuilder.buildHierarchy(it, realizeTasks)).collect(Collectors.toList());
        ProjectInternal mutableProject = project.getMutableModel();
        String projectIdentityPath = project.getIdentityPath().asString();
        DefaultGradleProject gradleProject = new DefaultGradleProject().setProjectIdentifier(new DefaultProjectIdentifier(mutableProject.getRootDir(), mutableProject.getPath())).setName(mutableProject.getName()).setDescription(mutableProject.getDescription()).setBuildDirectory((File)mutableProject.getLayout().getBuildDirectory().getAsFile().get()).setProjectDirectory(mutableProject.getProjectDir()).setBuildTreePath(projectIdentityPath).setChildren(children);
        gradleProject.getBuildScript().setSourceFile(mutableProject.getBuildFile());
        for (DefaultGradleProject child : children) {
            child.setParent(gradleProject);
        }
        if (realizeTasks) {
            List tasks = (List)project.fromMutableState(p -> GradleProjectBuilder.collectTasks(gradleProject, p.getTasks()));
            gradleProject.setTasks(tasks);
        }
        return gradleProject;
    }

    private static List<LaunchableGradleProjectTask> collectTasks(DefaultGradleProject owner, TaskContainerInternal tasks) {
        tasks.discoverTasks();
        tasks.realize();
        return tasks.getNames().stream().map(arg_0 -> ((TaskContainerInternal)tasks).findByName(arg_0)).filter(Objects::nonNull).map(task -> GradleProjectBuilder.buildTask(owner, task)).collect(Collectors.toList());
    }

    private static LaunchableGradleProjectTask buildTask(DefaultGradleProject owner, Task task) {
        LaunchableGradleProjectTask model = ToolingModelBuilderSupport.buildFromTask(new LaunchableGradleProjectTask(), owner.getProjectIdentifier(), task);
        model.setProject(owner);
        return model;
    }
}

