/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.failure;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.gradle.api.internal.tasks.testing.failure.ThrowableToTestFailureMapper;
import org.gradle.api.tasks.testing.TestFailure;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class TestFailureMapper {
    public boolean supports(Class<?> cls) {
        if (this.getSupportedClassNames().contains(cls.getName())) {
            return true;
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass == null) {
            return false;
        }
        return this.supports(superclass);
    }

    protected abstract List<String> getSupportedClassNames();

    public abstract TestFailure map(Throwable var1, ThrowableToTestFailureMapper var2) throws Exception;

    protected static <T> @Nullable T invokeMethod(@Nullable Object obj, String methodName, Class<T> targetClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (obj == null) {
            return null;
        }
        Method method = obj.getClass().getMethod(methodName, new Class[0]);
        Object result = method.invoke(obj, new Object[0]);
        if (result == null) {
            return null;
        }
        return targetClass.cast(result);
    }

    protected static @Nullable Object invokeMethod(@Nullable Object obj, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return TestFailureMapper.invokeMethod(obj, methodName, Object.class);
    }
}

