/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

public interface FileHasherStatistics {
    public long getHashedFileCount();

    public long getHashedContentLength();

    @ServiceScope(value={Scope.Global.class})
    public static class Collector {
        private final AtomicLong hashedFileCount = new AtomicLong();
        private final AtomicLong hashedContentLength = new AtomicLong();

        public void reportFileHashed(long length) {
            this.hashedFileCount.incrementAndGet();
            this.hashedContentLength.addAndGet(length);
        }

        public FileHasherStatistics collect() {
            final long hashedFileCount = this.hashedFileCount.getAndSet(0L);
            final long hashedContentLength = this.hashedContentLength.getAndSet(0L);
            return new FileHasherStatistics(){

                @Override
                public long getHashedFileCount() {
                    return hashedFileCount;
                }

                @Override
                public long getHashedContentLength() {
                    return hashedContentLength;
                }

                public String toString() {
                    return MessageFormat.format("Hashed {0,number,integer} files ({1,number,integer} bytes)", hashedFileCount, hashedContentLength);
                }
            };
        }
    }
}

