/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.io.File;
import java.util.Optional;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.steps.IdentityContext;
import org.jspecify.annotations.Nullable;

public class WorkspaceContext
extends IdentityContext {
    private final File workspace;
    private final ExecutionHistoryStore history;
    private final boolean captureBeforeExecutionState;

    public WorkspaceContext(IdentityContext parent, File workspace, @Nullable ExecutionHistoryStore history, boolean captureBeforeExecutionState) {
        super(parent);
        this.workspace = workspace;
        this.history = history;
        this.captureBeforeExecutionState = captureBeforeExecutionState;
    }

    protected WorkspaceContext(WorkspaceContext parent) {
        this(parent, parent.getWorkspace(), parent.getHistory().orElse(null), parent.shouldCaptureBeforeExecutionState());
    }

    public File getWorkspace() {
        return this.workspace;
    }

    public boolean shouldCaptureBeforeExecutionState() {
        return this.captureBeforeExecutionState;
    }

    public Optional<ExecutionHistoryStore> getHistory() {
        return Optional.ofNullable(this.history);
    }
}

