/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.accessors;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.kotlin.dsl.accessors.AccessorsClassPath;
import org.gradle.kotlin.dsl.accessors.AccessorsClassPathKt;
import org.gradle.kotlin.dsl.accessors.GenerateProjectAccessors;
import org.gradle.kotlin.dsl.accessors.ProjectSchema;
import org.gradle.kotlin.dsl.accessors.ProjectSchemaProvider;
import org.gradle.kotlin.dsl.accessors.SchemaType;
import org.gradle.kotlin.dsl.cache.KotlinDslWorkspaceProvider;
import org.gradle.kotlin.dsl.concurrent.AsyncIOScopeFactory;
import org.jetbrains.annotations.NotNull;

@ServiceScope(value={Scope.Build.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B9\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cj\u0004\u0018\u0001`\u001e2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/gradle/kotlin/dsl/accessors/ProjectAccessorsClassPathGenerator;", "", "fileCollectionFactory", "Lorg/gradle/api/internal/file/FileCollectionFactory;", "projectSchemaProvider", "Lorg/gradle/kotlin/dsl/accessors/ProjectSchemaProvider;", "executionEngine", "Lorg/gradle/internal/execution/ExecutionEngine;", "inputFingerprinter", "Lorg/gradle/internal/execution/InputFingerprinter;", "workspaceProvider", "Lorg/gradle/kotlin/dsl/cache/KotlinDslWorkspaceProvider;", "asyncIO", "Lorg/gradle/kotlin/dsl/concurrent/AsyncIOScopeFactory;", "<init>", "(Lorg/gradle/api/internal/file/FileCollectionFactory;Lorg/gradle/kotlin/dsl/accessors/ProjectSchemaProvider;Lorg/gradle/internal/execution/ExecutionEngine;Lorg/gradle/internal/execution/InputFingerprinter;Lorg/gradle/kotlin/dsl/cache/KotlinDslWorkspaceProvider;Lorg/gradle/kotlin/dsl/concurrent/AsyncIOScopeFactory;)V", "classPathCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/gradle/api/internal/initialization/ClassLoaderScope;", "Lorg/gradle/kotlin/dsl/accessors/AccessorsClassPath;", "projectAccessorsClassPath", "scriptTarget", "Lorg/gradle/api/plugins/ExtensionAware;", "classPath", "Lorg/gradle/internal/classpath/ClassPath;", "buildAccessorsClassPathFor", "classLoaderScope", "configuredProjectSchemaOf", "Lorg/gradle/kotlin/dsl/accessors/ProjectSchema;", "Lorg/gradle/kotlin/dsl/accessors/SchemaType;", "Lorg/gradle/kotlin/dsl/accessors/TypedProjectSchema;", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nAccessorsClassPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessorsClassPath.kt\norg/gradle/kotlin/dsl/accessors/ProjectAccessorsClassPathGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,821:1\n1#2:822\n*E\n"})
public final class ProjectAccessorsClassPathGenerator {
    @NotNull
    private final FileCollectionFactory fileCollectionFactory;
    @NotNull
    private final ProjectSchemaProvider projectSchemaProvider;
    @NotNull
    private final ExecutionEngine executionEngine;
    @NotNull
    private final InputFingerprinter inputFingerprinter;
    @NotNull
    private final KotlinDslWorkspaceProvider workspaceProvider;
    @NotNull
    private final AsyncIOScopeFactory asyncIO;
    @NotNull
    private final ConcurrentHashMap<ClassLoaderScope, AccessorsClassPath> classPathCache;

    @Inject
    public ProjectAccessorsClassPathGenerator(@NotNull FileCollectionFactory fileCollectionFactory, @NotNull ProjectSchemaProvider projectSchemaProvider, @NotNull ExecutionEngine executionEngine, @NotNull InputFingerprinter inputFingerprinter, @NotNull KotlinDslWorkspaceProvider workspaceProvider, @NotNull AsyncIOScopeFactory asyncIO) {
        Intrinsics.checkNotNullParameter((Object)fileCollectionFactory, (String)"fileCollectionFactory");
        Intrinsics.checkNotNullParameter((Object)projectSchemaProvider, (String)"projectSchemaProvider");
        Intrinsics.checkNotNullParameter((Object)executionEngine, (String)"executionEngine");
        Intrinsics.checkNotNullParameter((Object)inputFingerprinter, (String)"inputFingerprinter");
        Intrinsics.checkNotNullParameter((Object)workspaceProvider, (String)"workspaceProvider");
        Intrinsics.checkNotNullParameter((Object)asyncIO, (String)"asyncIO");
        this.fileCollectionFactory = fileCollectionFactory;
        this.projectSchemaProvider = projectSchemaProvider;
        this.executionEngine = executionEngine;
        this.inputFingerprinter = inputFingerprinter;
        this.workspaceProvider = workspaceProvider;
        this.asyncIO = asyncIO;
        this.classPathCache = new ConcurrentHashMap();
    }

    @NotNull
    public final AccessorsClassPath projectAccessorsClassPath(@NotNull ExtensionAware scriptTarget, @NotNull ClassPath classPath) {
        Intrinsics.checkNotNullParameter((Object)scriptTarget, (String)"scriptTarget");
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        ClassLoaderScope classLoaderScope = AccessorsClassPathKt.access$classLoaderScopeOf(scriptTarget);
        if (classLoaderScope == null) {
            return AccessorsClassPath.Companion.getEmpty();
        }
        AccessorsClassPath accessorsClassPath = this.classPathCache.computeIfAbsent(classLoaderScope, new Function(this, classLoaderScope, scriptTarget, classPath){
            final /* synthetic */ ProjectAccessorsClassPathGenerator this$0;
            final /* synthetic */ ClassLoaderScope $classLoaderScope;
            final /* synthetic */ ExtensionAware $scriptTarget;
            final /* synthetic */ ClassPath $classPath;
            {
                this.this$0 = $receiver;
                this.$classLoaderScope = $classLoaderScope;
                this.$scriptTarget = $scriptTarget;
                this.$classPath = $classPath;
            }

            public final AccessorsClassPath apply(ClassLoaderScope it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AccessorsClassPath accessorsClassPath = ProjectAccessorsClassPathGenerator.access$buildAccessorsClassPathFor(this.this$0, this.$classLoaderScope, this.$scriptTarget, this.$classPath);
                if (accessorsClassPath == null) {
                    accessorsClassPath = AccessorsClassPath.Companion.getEmpty();
                }
                return accessorsClassPath;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)accessorsClassPath, (String)"computeIfAbsent(...)");
        return accessorsClassPath;
    }

    private final AccessorsClassPath buildAccessorsClassPathFor(ClassLoaderScope classLoaderScope, Object scriptTarget, ClassPath classPath) {
        AccessorsClassPath accessorsClassPath;
        ProjectSchema<SchemaType> projectSchema = this.configuredProjectSchemaOf(scriptTarget, classLoaderScope);
        if (projectSchema != null) {
            ProjectSchema<SchemaType> scriptTargetSchema = projectSchema;
            boolean bl = false;
            GenerateProjectAccessors work = new GenerateProjectAccessors(scriptTarget, scriptTargetSchema, classPath, this.fileCollectionFactory, this.inputFingerprinter, this.workspaceProvider, this.asyncIO, AccessorsClassPathKt.isDclEnabledForScriptTarget(scriptTarget));
            accessorsClassPath = (AccessorsClassPath)this.executionEngine.createRequest((UnitOfWork)work).execute().getOutputAs(AccessorsClassPath.class).get();
        } else {
            accessorsClassPath = null;
        }
        return accessorsClassPath;
    }

    private final ProjectSchema<SchemaType> configuredProjectSchemaOf(Object scriptTarget, ClassLoaderScope classLoaderScope) {
        ProjectSchema<SchemaType> projectSchema;
        if (!classLoaderScope.isLocked()) {
            boolean bl = false;
            String string = "project.classLoaderScope must be locked before querying the project schema";
            throw new IllegalArgumentException(string.toString());
        }
        ProjectSchema<SchemaType> projectSchema2 = this.projectSchemaProvider.schemaFor(scriptTarget, classLoaderScope);
        if (projectSchema2 != null) {
            ProjectSchema<SchemaType> projectSchema3;
            ProjectSchema<SchemaType> it = projectSchema3 = projectSchema2;
            boolean bl = false;
            projectSchema = it.isNotEmpty() ? projectSchema3 : null;
        } else {
            projectSchema = null;
        }
        return projectSchema;
    }

    public static final /* synthetic */ AccessorsClassPath access$buildAccessorsClassPathFor(ProjectAccessorsClassPathGenerator $this, ClassLoaderScope classLoaderScope, Object scriptTarget, ClassPath classPath) {
        return $this.buildAccessorsClassPathFor(classLoaderScope, scriptTarget, classPath);
    }
}

