/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instrumentation.agent;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.internal.classloader.InstrumentingClassLoader;
import org.gradle.internal.instrumentation.agent.AgentControl;
import org.jspecify.annotations.Nullable;

class DefaultClassFileTransformer
implements ClassFileTransformer {
    private static final AtomicBoolean INSTALLED = new AtomicBoolean();

    DefaultClassFileTransformer() {
    }

    @Override
    public byte @Nullable [] transform(@Nullable ClassLoader loader, @Nullable String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (!(loader instanceof InstrumentingClassLoader)) {
            return null;
        }
        InstrumentingClassLoader instrumentingLoader = (InstrumentingClassLoader)loader;
        try {
            return instrumentingLoader.instrumentClass(className, protectionDomain, classfileBuffer);
        }
        catch (Throwable th) {
            instrumentingLoader.transformFailed(className, th);
            return null;
        }
    }

    public static boolean tryInstall() {
        if (!INSTALLED.compareAndSet(false, true)) {
            throw new IllegalStateException("The transformer is already installed in " + DefaultClassFileTransformer.class.getClassLoader());
        }
        return AgentControl.installTransformer(new DefaultClassFileTransformer());
    }
}

