/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.SoftwareFeatureApplicationContext;
import org.gradle.api.internal.plugins.software.SoftwareType;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.internal.Cast;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.extensibility.ExtensibleDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.model.internal.type.ModelType;
import org.gradle.plugin.software.internal.LegacySoftwareTypeImplementation;
import org.gradle.plugin.software.internal.ModelDefaultsApplicator;
import org.gradle.plugin.software.internal.SoftwareFeatureApplicator;
import org.gradle.plugin.software.internal.SoftwareFeatureImplementation;
import org.gradle.plugin.software.internal.SoftwareFeatureRegistry;
import org.gradle.plugin.software.internal.SoftwareFeatureSupportInternal;
import org.gradle.plugin.software.internal.SoftwareFeaturesDynamicObject;
import org.jspecify.annotations.NullMarked;

public class DefaultSoftwareFeatureApplicator
implements SoftwareFeatureApplicator {
    private final SoftwareFeatureRegistry softwareFeatureRegistry;
    private final ModelDefaultsApplicator modelDefaultsApplicator;
    private final InspectionScheme inspectionScheme;
    private final InternalProblems problems;
    private final PluginManagerInternal pluginManager;
    private final Set<AppliedFeature> applied = new HashSet<AppliedFeature>();
    private final ClassLoaderScope classLoaderScope;
    private final ObjectFactory objectFactory;

    public DefaultSoftwareFeatureApplicator(SoftwareFeatureRegistry softwareFeatureRegistry, ModelDefaultsApplicator modelDefaultsApplicator, InspectionScheme inspectionScheme, InternalProblems problems, PluginManagerInternal pluginManager, ClassLoaderScope classLoaderScope, ObjectFactory objectFactory) {
        this.softwareFeatureRegistry = softwareFeatureRegistry;
        this.modelDefaultsApplicator = modelDefaultsApplicator;
        this.inspectionScheme = inspectionScheme;
        this.problems = problems;
        this.pluginManager = pluginManager;
        this.classLoaderScope = classLoaderScope;
        this.objectFactory = objectFactory;
    }

    public <T, V> T applyFeatureTo(ExtensionAware target, SoftwareFeatureImplementation<T, V> softwareFeature) {
        AppliedFeature appliedFeature = new AppliedFeature(target, softwareFeature);
        if (!this.applied.contains(appliedFeature)) {
            if (!(softwareFeature instanceof LegacySoftwareTypeImplementation)) {
                T dslObject = this.createDslObject(target, softwareFeature);
                V buildModelObject = DefaultSoftwareFeatureApplicator.createBuildModelObject((ExtensionAware)dslObject, softwareFeature);
                SoftwareFeatureApplicationContext context = (SoftwareFeatureApplicationContext)this.objectFactory.newInstance(SoftwareFeatureApplicationContext.class, new Object[0]);
                softwareFeature.getBindingTransform().transform(context, dslObject, Cast.uncheckedCast(buildModelObject), Cast.uncheckedCast((Object)target));
            }
            this.pluginManager.apply(softwareFeature.getPluginClass());
            Plugin plugin = this.pluginManager.getPluginContainer().getPlugin(softwareFeature.getPluginClass());
            this.applyAndMaybeRegisterExtension(target, softwareFeature, plugin);
            this.applied.add(appliedFeature);
            this.modelDefaultsApplicator.applyDefaultsTo((Object)target, (ModelDefaultsApplicator.ClassLoaderContext)new ClassLoaderContextFromScope(this.classLoaderScope), plugin, softwareFeature);
        }
        return (T)Cast.uncheckedCast((Object)target.getExtensions().getByName(softwareFeature.getFeatureName()));
    }

    private <T, V> T createDslObject(ExtensionAware target, SoftwareFeatureImplementation<T, V> softwareFeature) {
        Class dslType = softwareFeature.getDefinitionImplementationType();
        if (Named.class.isAssignableFrom(dslType)) {
            if (Named.class.isAssignableFrom(target.getClass())) {
                Object result = target.getExtensions().create(softwareFeature.getFeatureName(), dslType, new Object[]{((Named)target).getName()});
                this.initializeDefinitionDslObject(result);
                return (T)result;
            }
            throw new IllegalArgumentException("Cannot infer a name for " + dslType.getSimpleName() + " because the parent object of type " + target.getClass().getSimpleName() + " does not implement Named.");
        }
        Object result = target.getExtensions().create(softwareFeature.getFeatureName(), dslType, new Object[0]);
        this.initializeDefinitionDslObject(result);
        return (T)result;
    }

    private void initializeDefinitionDslObject(Object dslObjectToInitialize) {
        ExtensionAware dslObject = (ExtensionAware)dslObjectToInitialize;
        SoftwareFeatureSupportInternal.registerContextIfAbsent((ExtensionAware)dslObject, (SoftwareFeatureApplicator)this, (SoftwareFeatureRegistry)this.softwareFeatureRegistry);
        this.addSoftwafeFeatureDynamicObjectToDefinition((DynamicObjectAware)dslObjectToInitialize);
    }

    private void addSoftwafeFeatureDynamicObjectToDefinition(DynamicObjectAware dslObjectToInitialize) {
        ((ExtensibleDynamicObject)dslObjectToInitialize.getAsDynamicObject()).addObject((DynamicObject)this.objectFactory.newInstance(SoftwareFeaturesDynamicObject.class, new Object[]{dslObjectToInitialize}), ExtensibleDynamicObject.Location.BeforeConvention);
    }

    private static <V> V createBuildModelObject(ExtensionAware target, SoftwareFeatureImplementation<?, V> softwareFeature) {
        Class buildModelType = softwareFeature.getBuildModelImplementationType();
        if (Named.class.isAssignableFrom(buildModelType)) {
            if (Named.class.isAssignableFrom(target.getClass())) {
                return (V)target.getExtensions().create("model", buildModelType, new Object[]{((Named)target).getName()});
            }
            throw new IllegalArgumentException("Cannot infer a name for " + buildModelType.getSimpleName() + " because the parent object of type " + target.getClass().getSimpleName() + " does not implement Named.");
        }
        return (V)target.getExtensions().create("model", buildModelType, new Object[0]);
    }

    private <T, V> void applyAndMaybeRegisterExtension(ExtensionAware target, SoftwareFeatureImplementation<T, V> softwareFeature, Plugin<?> plugin) {
        DefaultTypeValidationContext typeValidationContext = DefaultTypeValidationContext.withRootType((Class)softwareFeature.getPluginClass(), (boolean)false, (InternalProblems)this.problems);
        ExtensionAddingVisitor extensionAddingVisitor = new ExtensionAddingVisitor(target, typeValidationContext, this.softwareFeatureRegistry, this);
        this.inspectionScheme.getPropertyWalker().visitProperties(plugin, (TypeValidationContext)typeValidationContext, extensionAddingVisitor);
        if (!typeValidationContext.getProblems().isEmpty()) {
            throw new DefaultMultiCauseException(String.format(typeValidationContext.getProblems().size() == 1 ? "A problem was found with the %s plugin." : "Some problems were found with the %s plugin.", DefaultSoftwareFeatureApplicator.getPluginObjectDisplayName(plugin)), (Iterable)typeValidationContext.getProblems().stream().map(TypeValidationProblemRenderer::renderMinimalInformationAbout).sorted().map(InvalidUserDataException::new).collect(ImmutableList.toImmutableList()));
        }
    }

    private static String getPluginObjectDisplayName(Object parameterObject) {
        return ModelType.of((Class)new DslObject(parameterObject).getDeclaredType()).getDisplayName();
    }

    private static class AppliedFeature {
        private final Object target;
        private final SoftwareFeatureImplementation<?, ?> softwareFeature;

        public AppliedFeature(Object target, SoftwareFeatureImplementation<?, ?> softwareFeature) {
            this.target = target;
            this.softwareFeature = softwareFeature;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AppliedFeature that = (AppliedFeature)o;
            return this.target == that.target && Objects.equals(this.softwareFeature, that.softwareFeature);
        }

        public int hashCode() {
            int result = System.identityHashCode(this.target);
            result = 31 * result + this.softwareFeature.hashCode();
            return result;
        }
    }

    private static class ClassLoaderContextFromScope
    implements ModelDefaultsApplicator.ClassLoaderContext {
        private final ClassLoaderScope scope;

        public ClassLoaderContextFromScope(ClassLoaderScope scope) {
            this.scope = scope;
        }

        public ClassLoader getClassLoader() {
            return this.scope.getLocalClassLoader();
        }

        public ClassLoader getParentClassLoader() {
            return this.scope.getParent().getLocalClassLoader();
        }
    }

    @NullMarked
    public static class ExtensionAddingVisitor<T>
    implements PropertyVisitor {
        private final ExtensionAware target;
        private final DefaultTypeValidationContext validationContext;
        private final SoftwareFeatureApplicator applicator;
        private final SoftwareFeatureRegistry softwareFeatureRegistry;

        public ExtensionAddingVisitor(ExtensionAware target, DefaultTypeValidationContext validationContext, SoftwareFeatureRegistry softwareFeatureRegistry, SoftwareFeatureApplicator applicator) {
            this.target = target;
            this.validationContext = validationContext;
            this.softwareFeatureRegistry = softwareFeatureRegistry;
            this.applicator = applicator;
        }

        public void visitSoftwareTypeProperty(String propertyName, PropertyValue value, Class<?> declaredPropertyType, SoftwareType softwareType) {
            Object publicModelObject = Cast.uncheckedNonnullCast((Object)Objects.requireNonNull(value.call()));
            if (publicModelObject instanceof ExtensionAware) {
                SoftwareFeatureSupportInternal.registerContextIfAbsent((ExtensionAware)((ExtensionAware)publicModelObject), (SoftwareFeatureApplicator)this.applicator, (SoftwareFeatureRegistry)this.softwareFeatureRegistry);
            }
            if (softwareType.disableModelManagement()) {
                Object extension = this.target.getExtensions().findByName(softwareType.name());
                if (extension == null) {
                    this.validationContext.visitPropertyProblem(problem -> problem.forProperty(propertyName).id("extension-not-registered-for-software-type", "was not registered as an extension", GradleCoreProblemGroup.validation().property()).contextualLabel("has @SoftwareType annotation with 'disableModelManagement' set to true, but no extension with name '" + softwareType.name() + "' was registered").severity(Severity.ERROR).details("When 'disableModelManagement' is set, the plugin must register the '" + propertyName + "' property as an extension with the same name as the software type.").solution("During plugin application, register the '" + propertyName + "' property as an extension with the name '" + softwareType.name() + "'.").solution("Set 'disableModelManagement' to false or remove the parameter from the @SoftwareType annotation."));
                } else if (extension != publicModelObject) {
                    this.validationContext.visitPropertyProblem(problem -> problem.forProperty(propertyName).id("mismatched-extension-registered-for-software-type", "does not match the extension registered as '" + softwareType.name(), GradleCoreProblemGroup.validation().property()).contextualLabel("has @SoftwareType annotation with 'disableModelManagement' set to true, but the extension with name '" + softwareType.name() + "' does not match the value of the property").severity(Severity.ERROR).details("When 'disableModelManagement' is set, the plugin must register the '" + propertyName + "' property as an extension with the same name as the software type.").solution("During plugin application, register the '" + propertyName + "' property as an extension with the name '" + softwareType.name() + "'."));
                }
            } else {
                this.target.getExtensions().add(this.publicTypeFrom(softwareType.modelPublicType(), declaredPropertyType), softwareType.name(), publicModelObject);
            }
        }

        private Class<? super T> publicTypeFrom(Class<?> fromAnnotation, Class<?> declaredPropertyType) {
            return (Class)Cast.uncheckedCast(fromAnnotation == Void.class ? declaredPropertyType : fromAnnotation);
        }
    }
}

