/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp.version;

import java.io.File;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioInstallCandidate;
import org.gradle.util.internal.VersionNumber;
import org.jspecify.annotations.Nullable;

public class DefaultVisualStudioMetadata
implements VisualStudioInstallCandidate {
    private final File installDir;
    private final File visualCppDir;
    private final VersionNumber version;
    private final VersionNumber visualCppVersion;
    private final VisualStudioInstallCandidate.Compatibility compatibility;

    DefaultVisualStudioMetadata(File installDir, @Nullable File visualCppDir, VersionNumber version, @Nullable VersionNumber visualCppVersion, VisualStudioInstallCandidate.Compatibility compatibility) {
        this.installDir = installDir;
        this.visualCppDir = visualCppDir;
        this.version = version;
        this.visualCppVersion = visualCppVersion;
        this.compatibility = compatibility;
    }

    @Override
    public File getInstallDir() {
        return this.installDir;
    }

    @Override
    public File getVisualCppDir() {
        return this.visualCppDir;
    }

    @Override
    public VersionNumber getVersion() {
        return this.version;
    }

    @Override
    public VersionNumber getVisualCppVersion() {
        return this.visualCppVersion;
    }

    @Override
    public VisualStudioInstallCandidate.Compatibility getCompatibility() {
        if (this.compatibility != null) {
            return this.compatibility;
        }
        if (this.version.getMajor() >= 15) {
            return VisualStudioInstallCandidate.Compatibility.VS2017_OR_LATER;
        }
        return VisualStudioInstallCandidate.Compatibility.LEGACY;
    }
}

