/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.properties;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.Environment;
import org.gradle.initialization.properties.GradlePropertiesLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGradlePropertiesLoader
implements GradlePropertiesLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGradlePropertiesLoader.class);
    private final StartParameterInternal startParameter;
    private final Environment environment;

    public DefaultGradlePropertiesLoader(StartParameterInternal startParameter, Environment environment) {
        this.startParameter = startParameter;
        this.environment = environment;
    }

    @Override
    public Map<String, String> loadFromGradleHome() {
        return this.loadFrom(this.startParameter.getGradleHomeDir());
    }

    @Override
    public Map<String, String> loadFromGradleUserHome() {
        return this.loadFrom(this.startParameter.getGradleUserHomeDir());
    }

    @Override
    public Map<String, String> loadFrom(File dir) {
        Map<String, String> loadedProperties = this.environment.propertiesFile(new File(dir, "gradle.properties"));
        return loadedProperties == null ? Collections.emptyMap() : loadedProperties;
    }

    @Override
    public Map<String, String> loadFromSystemProperties() {
        Map<String, String> systemProjectProperties = DefaultGradlePropertiesLoader.byPrefix("org.gradle.project.", this.environment.getSystemProperties());
        LOGGER.debug("Found system project properties: {}", systemProjectProperties.keySet());
        return systemProjectProperties;
    }

    @Override
    public Map<String, String> loadFromEnvironmentVariables() {
        Map<String, String> envProjectProperties = DefaultGradlePropertiesLoader.byPrefix("ORG_GRADLE_PROJECT_", this.environment.getVariables());
        LOGGER.debug("Found env project properties: {}", envProjectProperties.keySet());
        return envProjectProperties;
    }

    @Override
    public Map<String, String> loadFromStartParameterProjectProperties() {
        return this.startParameter.getProjectProperties();
    }

    private static Map<String, String> byPrefix(String prefix, Environment.Properties properties) {
        return DefaultGradlePropertiesLoader.mapKeysRemovingPrefix(prefix, properties.byNamePrefix(prefix));
    }

    private static Map<String, String> mapKeysRemovingPrefix(String prefix, Map<String, String> mapWithPrefix) {
        HashMap<String, String> mapWithoutPrefix = new HashMap<String, String>(mapWithPrefix.size());
        for (Map.Entry<String, String> entry : mapWithPrefix.entrySet()) {
            mapWithoutPrefix.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
        return mapWithoutPrefix;
    }
}

