/*
 * Copyright 2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import gradlebuild.basics.accessors.kotlin
import gradlebuild.kotlindsl.generator.tasks.GenerateKotlinDslPluginsExtensions

plugins {
    java
}

val generatedSourcesDir = layout.buildDirectory.dir("generated-sources/kotlin")

val generateSources by tasks.registering(GenerateKotlinDslPluginsExtensions::class) {
    outputDir.set(generatedSourcesDir)
    kotlinDslPluginsVersion.set(project.version)
}

sourceSets.main {
    kotlin.srcDir(files(generatedSourcesDir).builtBy(generateSources))
}
