/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.compile.ApiCompilerResult;

public class CompilationFailedException
extends RuntimeException {
    private final ApiCompilerResult compilerPartialResult;

    public CompilationFailedException() {
        this((ApiCompilerResult)null);
    }

    public CompilationFailedException(@Nullable ApiCompilerResult compilerPartialResult) {
        super("Compilation failed; see the compiler error output for details.");
        this.compilerPartialResult = compilerPartialResult;
    }

    public CompilationFailedException(int exitCode) {
        super(String.format("Compilation failed with exit code %d; see the compiler error output for details.", exitCode));
        this.compilerPartialResult = null;
    }

    public CompilationFailedException(Throwable cause) {
        super(cause);
        this.compilerPartialResult = null;
    }

    public Optional<ApiCompilerResult> getCompilerPartialResult() {
        return Optional.ofNullable(this.compilerPartialResult);
    }
}

