/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import com.google.common.base.Charsets;
import com.google.common.io.CharSource;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.resources.CharSourceBackedTextResource;
import org.gradle.api.resources.TextResource;
import org.gradle.internal.io.IoUtils;
import org.gradle.jvm.application.scripts.JavaAppStartScriptGenerationDetails;
import org.gradle.jvm.application.scripts.TemplateBasedScriptGenerator;
import org.gradle.util.internal.TextUtil;

public class DefaultTemplateBasedStartScriptGenerator
implements TemplateBasedScriptGenerator {
    private final String lineSeparator;
    private final Transformer<Map<String, String>, JavaAppStartScriptGenerationDetails> bindingFactory;
    private TextResource template;

    public DefaultTemplateBasedStartScriptGenerator(String lineSeparator, Transformer<Map<String, String>, JavaAppStartScriptGenerationDetails> bindingFactory, TextResource template) {
        this.lineSeparator = lineSeparator;
        this.bindingFactory = bindingFactory;
        this.template = template;
    }

    @Override
    public void generateScript(JavaAppStartScriptGenerationDetails details, Writer destination) {
        try {
            Map binding = (Map)this.bindingFactory.transform((Object)details);
            String scriptContent = this.generateStartScriptContentFromTemplate(binding);
            destination.write(scriptContent);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    @Override
    public void setTemplate(TextResource template) {
        this.template = template;
    }

    @Override
    public TextResource getTemplate() {
        return this.template;
    }

    private String generateStartScriptContentFromTemplate(final Map<String, String> binding) {
        return (String)IoUtils.get((Closeable)this.getTemplate().asReader(), (Transformer)new Transformer<String, Reader>(){

            public String transform(Reader reader) {
                try {
                    SimpleTemplateEngine engine = new SimpleTemplateEngine();
                    Template template = engine.createTemplate(reader);
                    String output = template.make(binding).toString();
                    return TextUtil.convertLineSeparators((String)output, (String)DefaultTemplateBasedStartScriptGenerator.this.lineSeparator);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        });
    }

    protected static TextResource utf8ClassPathResource(final Class<?> clazz, final String filename) {
        return new CharSourceBackedTextResource("Classpath resource '" + filename + "'", new CharSource(){

            public Reader openStream() throws IOException {
                InputStream stream = clazz.getResourceAsStream(filename);
                if (stream == null) {
                    throw new IllegalStateException("Could not find class path resource " + filename + " relative to " + clazz.getName());
                }
                return new BufferedReader(new InputStreamReader(stream, Charsets.UTF_8));
            }
        });
    }
}

